package ru.yandex.partner.testapi.fixture.block.mobile;

import org.jooq.DSLContext;
import org.springframework.stereotype.Service;

import ru.yandex.partner.testapi.fixture.FixtureUtils;
import ru.yandex.partner.testapi.fixture.block.BlockFixtureService;

import static ru.yandex.partner.dbschema.partner.Tables.MOBILE_APP_BLOCK_SEQ;
import static ru.yandex.partner.dbschema.partner.Tables.MOBILE_APP_SETTINGS;

@Service
public class PartnerMobileBlockFixtureService implements BlockFixtureService {
    private final DSLContext dslContext;

    public PartnerMobileBlockFixtureService(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public String getPageFixtureName() {
        throw new UnsupportedOperationException("Method must be implemented in block fixture");
    }

    @Override
    public String getPageIdFieldName() {
        return "page_id";
    }

    @Override
    public Long getNextBlockIdFromSeq(Long pageId) {
        return FixtureUtils.getNextId(pageId, dslContext,
                MOBILE_APP_BLOCK_SEQ.CONTEXT_PAGE_ID,
                MOBILE_APP_BLOCK_SEQ.NEXT_BLOCK_ID);
    }

    @Override
    public void updatePageBlocksCount(Long pageId) {
        dslContext.update(MOBILE_APP_SETTINGS)
                .set(MOBILE_APP_SETTINGS.BLOCKS_COUNT, MOBILE_APP_SETTINGS.BLOCKS_COUNT.plus(1))
                .where(MOBILE_APP_SETTINGS.ID.eq(pageId))
                .execute();
    }
}
