package ru.yandex.partner.testapi.fixture.block.video;

import java.time.LocalDateTime;

import org.jooq.DSLContext;

import ru.yandex.partner.dbschema.partner.Tables;
import ru.yandex.partner.dbschema.partner.tables.records.VideoAnSiteBlockSeqRecord;
import ru.yandex.partner.testapi.fixture.block.AbstractBlockFixture;
import ru.yandex.partner.testapi.fixture.page.PartnerVideoPageFixture;

public abstract class AbstractVideoAnSiteBlockFixture extends AbstractBlockFixture {

    protected final LocalDateTime localDateTime = LocalDateTime.of(2021, 12, 20, 17, 8, 15);

    public AbstractVideoAnSiteBlockFixture(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    public String getPageFixtureName() {
        return PartnerVideoPageFixture.FIXTURE_NAME;
    }

    @Override
    public String getPageIdFieldName() {
        return "page_id";
    }

    @Override
    protected Long getNextBlockIdFromSeq(Long pageId) {
        VideoAnSiteBlockSeqRecord videoAnSiteBlockSeqRecord = getDslContext().selectFrom(Tables.VIDEO_AN_SITE_BLOCK_SEQ)
                .where(Tables.VIDEO_AN_SITE_BLOCK_SEQ.SITE_ID.eq(pageId))
                .fetchOne();
        if (videoAnSiteBlockSeqRecord != null) {
            Long blockId = videoAnSiteBlockSeqRecord.getNextBlockId();
            getDslContext().update(Tables.VIDEO_AN_SITE_BLOCK_SEQ)
                    .set(Tables.VIDEO_AN_SITE_BLOCK_SEQ.NEXT_BLOCK_ID, blockId + 1)
                    .where(Tables.VIDEO_AN_SITE_BLOCK_SEQ.SITE_ID.eq(pageId))
                    .execute();
            return blockId;
        } else {
            long blockId = 1L;
            videoAnSiteBlockSeqRecord = new VideoAnSiteBlockSeqRecord();
            videoAnSiteBlockSeqRecord.setSiteId(pageId);
            videoAnSiteBlockSeqRecord.setNextBlockId(blockId + 1);
            getDslContext().insertInto(Tables.VIDEO_AN_SITE_BLOCK_SEQ)
                    .set(videoAnSiteBlockSeqRecord)
                    .execute();
            return blockId;
        }
    }

    @Override
    protected void updatePageBlocksCount(Long pageId) {
        getDslContext().update(Tables.VIDEO_AN_SITE)
                .set(Tables.VIDEO_AN_SITE.BLOCKS_COUNT, Tables.VIDEO_AN_SITE.BLOCKS_COUNT.plus(1))
                .where(Tables.VIDEO_AN_SITE.ID.eq(pageId))
                .execute();
    }
}
