package ru.yandex.partner.testapi.fixture.block.video;

import java.util.Map;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.VideoAnSiteFullscreen;
import ru.yandex.partner.dbschema.partner.tables.records.VideoAnSiteFullscreenRecord;

import static ru.yandex.partner.libs.utils.JooqUtils.applyPatchToRecord;

@Component
public class VideoAnSiteFullscreenBlockFixture extends AbstractVideoAnSiteBlockFixture {

    public static final String FIXTURE_NAME = "video_an_site_fullscreen_block";

    public VideoAnSiteFullscreenBlockFixture(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public String getPublicIDPrefix() {
        return "R-VF";
    }

    @Override
    protected Table<? extends Record> getTable() {
        return VideoAnSiteFullscreen.VIDEO_AN_SITE_FULLSCREEN;
    }

    @Override
    protected Record getBlockRecord(Long pageId, Long blockId, Map<String, Object> optsMap) {
        VideoAnSiteFullscreenRecord record = VideoAnSiteFullscreen.VIDEO_AN_SITE_FULLSCREEN.newRecord();
        record.setCreateDate(localDateTime);
        record.setPageId(pageId);
        record.setId(blockId);
        record.setCaption("Mocked Interstitial Block");
        record.setMultistate(22L);
        record.setType(3L);
        record.setGeo("[]");
        record.setMincpm(0L);
        record.setIsCustomBkData(0L);
        record.setAlternativeCode("");
        record.setBlind(0L);
        record.setStrategy(1L);
        record.setAdfoxBlock(0L);
        record.setOpts("{}");

        record.setMaxDuration(60L);
        record.setCategoryId(0L);
        record.setCategoryPath("Основной видеоресурс");
        record.setVideoMotion(1L);

        applyPatchToRecord(record, fieldTypes, optsMap);

        return record;
    }
}
