package ru.yandex.partner.testapi.fixture.block.video;

import java.util.Map;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.Tables;
import ru.yandex.partner.dbschema.partner.tables.records.VideoAnSiteInstreamRecord;

import static ru.yandex.partner.libs.utils.JooqUtils.applyPatchToRecord;

@Component
public class VideoAnSiteInstreamFixture extends AbstractVideoAnSiteBlockFixture {
    public static final String FIXTURE_NAME = "video_an_site_instream_block";

    public VideoAnSiteInstreamFixture(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public String getPublicIDPrefix() {
        return "R-V";
    }

    @Override
    protected Table<? extends Record> getTable() {
        return Tables.VIDEO_AN_SITE_INSTREAM;
    }

    @Override
    protected Record getBlockRecord(Long pageId, Long blockId, Map<String, Object> optsMap) {
        VideoAnSiteInstreamRecord record = new VideoAnSiteInstreamRecord();
        record.setCreateDate(localDateTime);
        record.setPageId(pageId);
        record.setId(blockId);
        record.setCaption("Mocked Instream Block");
        record.setMultistate(22L);
        record.setGeo("[]");
        record.setMincpm(0L);
        record.setIsCustomBkData(0L);
        record.setAlternativeCode("");
        record.setBlind(0L);
        record.setStrategy(1L);
        record.setAdfoxBlock(0L);
        record.setOpts("{}");

        record.setVmapId(1L);
        record.setMaxDuration(60L);
        record.setCategoryId(0L);
        record.setCategoryPath("Основной видеоресурс");
        record.setStartTime(10L);
        record.setRepeat(0L);
        record.setBroadcastReplace(0L);

        applyPatchToRecord(record, fieldTypes, optsMap);
        return record;
    }
}
