package ru.yandex.partner.testapi.fixture.dsp;

import java.util.List;
import java.util.function.Supplier;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.DSLContext;
import org.jooq.TableRecord;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.DspFormatRecord;
import ru.yandex.partner.dbschema.partner.tables.records.DspRecord;
import ru.yandex.partner.dbschema.partner.tables.records.DspTypeRecord;
import ru.yandex.partner.libs.utils.JooqUtils;
import ru.yandex.partner.testapi.fixture.Fixture;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;
import ru.yandex.partner.testapi.fixture.user.MockedDspPartnerFixture;

@Component
public class DspsFixture implements Fixture {
    public static final String FIXTURE_NAME = "dsps";
    private final DSLContext dslContext;

    public DspsFixture(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public List<String> getFixtureDepends() {
        return List.of(getUserFixtureName());
    }

    @Override
    public List<FixtureResult> createAndSave(JsonNode optsJson, FixtureContext fixtureContext) {
        Long ownerId = getOwnerId(fixtureContext);


        var dspTypes = create(DspTypeRecord::new, "/data/fixtures/dsp/dsp_type.json");
        save(dspTypes);

        var dspFormats = create(DspFormatRecord::new, "/data/fixtures/dsp/dsp_formats.json");
        save(dspFormats);

        var dsps = create(DspRecord::new, "/data/fixtures/dsp/dsp.json");
        for (DspRecord dsp : dsps) {
            dsp.setOwnerId(ownerId);
        }
        int count = save(dsps);
        return List.of(new FixtureResult(Integer.toString(count)));
    }

    private <TR extends TableRecord<TR>> List<TR> create(Supplier<TR> creator, String pathJsonResource) {
        return JooqUtils.jsonToRecords(pathJsonResource, creator);
    }

    private <TR extends TableRecord<TR>> int save(List<TR> list) {
        if (list.isEmpty()) {
            return 0;
        }
        var table = list.get(0).getTable();
        JooqUtils.insertRecords(dslContext, table, list);
        return list.size();
    }

    private String getUserFixtureName() {
        return MockedDspPartnerFixture.FIXTURE_NAME;
    }

    private Long getOwnerId(FixtureContext fixtureContext) {
        List<FixtureResult> userFixtureResults = fixtureContext.valueByFixtureName(getUserFixtureName());
        if (userFixtureResults == null || userFixtureResults.isEmpty()) {
            throw new RuntimeException("User fixture fail");
        }
        return (Long) userFixtureResults.get(0).getParams().get("id");
    }
}
