package ru.yandex.partner.testapi.fixture.fias;

import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.FiasRecord;
import ru.yandex.partner.libs.utils.JooqUtils;
import ru.yandex.partner.testapi.fixture.Fixture;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;

@Component
public class FiasFixture implements Fixture {

    private static final String TAEJNIY_GORODOK_GUID = "d83923de-04a1-45fa-a9a4-0ea4c3b296f3";
    private static final String LENINA_GUID = "c355a69f-ab05-40d1-857b-115c4ebf80fc";
    private final DSLContext dslContext;

    public FiasFixture(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public String getFixtureName() {
        return "fias_fixture";
    }

    @Override
    public List<String> getFixtureDepends() {
        return List.of();
    }

    @Override
    public List<FixtureResult> createAndSave(JsonNode optsJson, FixtureContext fixtureContext) {
        List<FiasRecord> magadanTree = JooqUtils
                .jsonToRecords("/data/fixtures/fias/magadan_tree.json", FiasRecord::new);
        List<FiasRecord> jewishTree = JooqUtils
                        .jsonToRecords("/data/fixtures/fias/jewish_tree.json", FiasRecord::new);

        dslContext.batchInsert(magadanTree).execute();
        dslContext.batchInsert(jewishTree).execute();

        return List.of(
                new FixtureResult(TAEJNIY_GORODOK_GUID),
                new FixtureResult(LENINA_GUID)
        );
    }
}
