package ru.yandex.partner.testapi.fixture.mobile;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.partner.testapi.fixture.user.MockedYanPartnerFixture;

@Component
public class PartnerMobileAppFixture extends AbstractMobileAppFixture {
    public static final String FIXTURE_NAME = "partner_mobile_app";
    private static final Long TYPE = 1L;
    private static final String STORE_ID = "ru.yandex.partner";
    private static final String STORE_URL = "https://play.google.com";

    public PartnerMobileAppFixture(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    public String getUserFixtureName() {
        return MockedYanPartnerFixture.FIXTURE_NAME;
    }

    @Override
    public Long getType() {
        return TYPE;
    }

    @Override
    public String getStoreId() {
        return STORE_ID;
    }

    @Override
    public String getStoreUrl() {
        return STORE_URL;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }
}
