package ru.yandex.partner.testapi.fixture.mobile;

import java.util.Map;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.MobileAppRecord;
import ru.yandex.partner.testapi.fixture.user.MockedYanPartnerFixture;

@Component
public class PartnerMobileMediationAppFixture extends AbstractMobileAppFixture {
    public static final String FIXTURE_NAME = "partner_mobile_mediation_app";
    private static final Long TYPE = 1L;
    private static final String STORE_ID = "ru.yandex.partner";
    private static final String STORE_URL = "https://play.google.com";

    public PartnerMobileMediationAppFixture(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    public String getUserFixtureName() {
        return MockedYanPartnerFixture.FIXTURE_NAME;
    }

    @Override
    public Long getType() {
        return TYPE;
    }

    @Override
    public String getStoreId() {
        return STORE_ID;
    }

    @Override
    public String getStoreUrl() {
        return STORE_URL;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public MobileAppRecord getMobileAppRecord(Map<String, Object> optsMap) {
        MobileAppRecord mobileAppRecord =  getDefaultMobileAppRecord(optsMap);
        mobileAppRecord.setOpts("{\"is_mobile_mediation\": 1}");
        return mobileAppRecord;
    }
}
