package ru.yandex.partner.testapi.fixture.page;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;

import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;
import ru.yandex.partner.testapi.service.PageIdGeneratorService;

public abstract class AbstractContextPageFixture extends AbstractSitePageFixture {

    protected final LocalDateTime localDateTime = LocalDateTime.of(2018, 10, 4, 20, 37, 23);

    public AbstractContextPageFixture(DSLContext dslContext, PageIdGeneratorService pageIdGeneratorService) {
        super(dslContext, pageIdGeneratorService);
    }

    protected FixtureResult createAndSaveForSiteIdAndUserId(Long siteId, Long userId) {
        Long pageId = getAndUpdateNextPageId();
        Record record = getCampaignRecord(siteId, userId, pageId);

        getDslContext().insertInto(getTable())
                .set(record)
                .execute();

        return new FixtureResult(
                Long.toString(pageId),
                Map.of(
                        "id", pageId,
                        "page_id", pageId
                )
        );
    }

    protected abstract Table<? extends Record> getTable();

    protected abstract Record getCampaignRecord(Long siteId, Long userId, Long pageId);

    @Override
    public List<FixtureResult> createAndSave(JsonNode optsJson, FixtureContext fixtureContext) {
        Long siteId = getSiteId(fixtureContext);
        Long userId = getUserId(fixtureContext);

        return List.of(createAndSaveForSiteIdAndUserId(siteId, userId));
    }

}
