package ru.yandex.partner.testapi.fixture.page;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.DSLContext;

import ru.yandex.partner.dbschema.partner.tables.records.MobileAppSettingsRecord;
import ru.yandex.partner.libs.utils.JooqUtils;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;
import ru.yandex.partner.testapi.fixture.FixtureUtils;
import ru.yandex.partner.testapi.service.PageIdGeneratorService;

public abstract class AbstractMobilePageFixture extends AbstractPageFixture {

    public AbstractMobilePageFixture(DSLContext dslContext, PageIdGeneratorService pageIdGeneratorService) {
        super(dslContext, pageIdGeneratorService);
    }

    public abstract String getMobileAppFixtureName();

    public Long getMobileAppId(FixtureContext fixtureContext) {
        List<FixtureResult> fixtureResult = fixtureContext.valueByFixtureName(getMobileAppFixtureName());
        if (fixtureResult == null || fixtureResult.isEmpty()) {
            throw new RuntimeException("MobileApp fixture fail");
        }
        return (Long) fixtureResult.get(0).getParams().get("id");
    }

    public MobileAppSettingsRecord getDefaultMobileAppSettingsRecord(Long mobileAppId, Long ownerId, Map<String,
            Object> optsMap) {
        LocalDateTime localDateTime = LocalDateTime.of(2018, 10, 4, 20, 37, 23);
        Long pageId = getAndUpdateNextPageId();
        MobileAppSettingsRecord mobileAppSettingsRecord = new MobileAppSettingsRecord();

        mobileAppSettingsRecord.setApplicationId(mobileAppId);
        mobileAppSettingsRecord.setBehavioralTargeting(1L);
        mobileAppSettingsRecord.setBlocksCount(0L);
        mobileAppSettingsRecord.setBlocksLimit(200L);
        mobileAppSettingsRecord.setBlockTitle("");
        mobileAppSettingsRecord.setCaption("Mocked YAN Partner Mobile Page");
        mobileAppSettingsRecord.setComment("");
        mobileAppSettingsRecord.setContextPageId(pageId);
        mobileAppSettingsRecord.setCreateDate(localDateTime);
        mobileAppSettingsRecord.setCreatorId(ownerId);
        mobileAppSettingsRecord.setFalseClick(1L);
        mobileAppSettingsRecord.setFamilyFilter(0L);
        mobileAppSettingsRecord.setFastContext(1L);
        mobileAppSettingsRecord.setId(pageId);
        mobileAppSettingsRecord.setMultistate(33L); // working, balance_registered
        mobileAppSettingsRecord.setOnlyPicture(0L);
        mobileAppSettingsRecord.setOpts("{\"is_mobile_mediation\": 0, \"order_tags\": [], \"target_tags\": []}");
        mobileAppSettingsRecord.setOwnerId(ownerId);
        mobileAppSettingsRecord.setPerformanceTgoDisable(0L);
        mobileAppSettingsRecord.setSendTime(localDateTime);
        mobileAppSettingsRecord.setTier(3L);
        mobileAppSettingsRecord.setUnmoderatedRtbAuction(0L);
        mobileAppSettingsRecord.setUpdateTime(localDateTime);
        mobileAppSettingsRecord.setViewImages(1L);

        JooqUtils.applyPatchToRecord(mobileAppSettingsRecord, optsMap);

        return mobileAppSettingsRecord;
    }

    public MobileAppSettingsRecord getMobileAppSettingsRecord(Long mobileAppId, Long ownerId,
                                                              Map<String, Object> optsMap) {
        return getDefaultMobileAppSettingsRecord(mobileAppId, ownerId, optsMap);
    }

    @Override
    public List<FixtureResult> createAndSave(JsonNode optsJson, FixtureContext fixtureContext) {
        List<Map<String, Object>> optsList = FixtureUtils.extractRecordPatches(optsJson);

        Long mobileAppId = getMobileAppId(fixtureContext);
        Long userId = getUserId(fixtureContext);

        List<MobileAppSettingsRecord> records = optsList.stream()
                .map(p -> getMobileAppSettingsRecord(mobileAppId, userId, p))
                .toList();

        getDslContext().batchInsert(records).execute();

        return records.stream()
                .map(r -> new FixtureResult(
                        Long.toString(r.getId()),
                        Map.of(
                                "id", r.getId(),
                                "page_id", r.getId()
                        )
                )).toList();
    }

    @Override
    public List<String> getFixtureDepends() {
        return List.of(
                getMobileAppFixtureName(),
                getUserFixtureName(),
                getDspFixtureName()
        );
    }
}
