package ru.yandex.partner.testapi.fixture.page;

import java.util.List;

import org.jooq.DSLContext;

import ru.yandex.partner.testapi.fixture.Fixture;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;
import ru.yandex.partner.testapi.fixture.dsp.DspsFixture;
import ru.yandex.partner.testapi.service.PageIdGeneratorService;

public abstract class AbstractPageFixture implements Fixture {
    private final DSLContext dslContext;
    private final PageIdGeneratorService pageIdGeneratorService;

    public AbstractPageFixture(DSLContext dslContext, PageIdGeneratorService pageIdGeneratorService) {
        this.dslContext = dslContext;
        this.pageIdGeneratorService = pageIdGeneratorService;
    }

    public abstract String getUserFixtureName();

    protected DSLContext getDslContext() {
        return dslContext;
    }

    public Long getAndUpdateNextPageId() {
        return pageIdGeneratorService.nextPageId(this.getClass().getName());
    }

    public Long getUserId(FixtureContext fixtureContext) {
        List<FixtureResult> fixtureResult = fixtureContext.valueByFixtureName(getUserFixtureName());
        if (fixtureResult == null || fixtureResult.isEmpty()) {
            throw new RuntimeException("User fixture fail");
        }
        return (Long) fixtureResult.get(0).getParams().get("id");
    }

    protected String getDspFixtureName() {
        return DspsFixture.FIXTURE_NAME;
    }
}
