package ru.yandex.partner.testapi.fixture.page;

import java.util.List;

import org.jooq.DSLContext;

import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;
import ru.yandex.partner.testapi.service.PageIdGeneratorService;

public abstract class AbstractSitePageFixture extends AbstractPageFixture {

    public AbstractSitePageFixture(DSLContext dslContext, PageIdGeneratorService pageIdGeneratorService) {
        super(dslContext, pageIdGeneratorService);
    }

    public abstract String getSiteFixtureName();

    public Long getSiteId(FixtureContext fixtureContext) {
        List<FixtureResult> fixtureResult = fixtureContext.valueByFixtureName(getSiteFixtureName());
        if (fixtureResult == null || fixtureResult.isEmpty()) {
            throw new RuntimeException("Site fixture fail");
        }
        return (Long) fixtureResult.get(0).getParams().get("id");
    }

    @Override
    public List<String> getFixtureDepends() {
        return List.of(
                getSiteFixtureName(),
                getUserFixtureName(),
                getDspFixtureName()
        );
    }
}
