package ru.yandex.partner.testapi.fixture.page;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.InternalContextOnSiteCampaignRecord;
import ru.yandex.partner.testapi.fixture.site.InternalSiteFixture;
import ru.yandex.partner.testapi.service.PageIdGeneratorService;

import static ru.yandex.partner.dbschema.partner.Tables.INTERNAL_CONTEXT_ON_SITE_CAMPAIGN;

@Component
public class InternalContextPageFixture extends AbstractContextPageFixture {
    public static final String FIXTURE_NAME = "internal_context_page";
    private static final String USER_FIXTURE_NAME = "internal_user";

    public InternalContextPageFixture(DSLContext dslContext,
                                      PageIdGeneratorService pageIdGeneratorService) {
        super(dslContext, pageIdGeneratorService);
    }

    @Override
    protected Table<? extends Record> getTable() {
        return INTERNAL_CONTEXT_ON_SITE_CAMPAIGN;
    }

    @Override
    protected Record getCampaignRecord(Long siteId, Long userId, Long pageId) {
        InternalContextOnSiteCampaignRecord internalRecord = getDefaultInternalCampaignRecord();

        internalRecord.setSiteId(siteId);
        internalRecord.setCreatorId(userId);

        internalRecord.setId(pageId);
        return internalRecord;
    }

    private InternalContextOnSiteCampaignRecord getDefaultInternalCampaignRecord() {
        Long pageId = getAndUpdateNextPageId();
        InternalContextOnSiteCampaignRecord campaignRecord = new InternalContextOnSiteCampaignRecord();
        campaignRecord.setId(pageId);
        campaignRecord.setCreateDate(localDateTime);
        campaignRecord.setFamilyFilter(0L);
        campaignRecord.setBehavioralTargeting(1L);
        campaignRecord.setViewImages(1L);
        campaignRecord.setReloadTimeout(30L);
        campaignRecord.setMultistate(17L); // working, in balance
        campaignRecord.setComment("");
        campaignRecord.setBlockTitle("");
        campaignRecord.setFastContext(1L);
        campaignRecord.setOnlyPicture(0L);
        campaignRecord.setMobileAppMode(0L);
        campaignRecord.setUpdateTime(localDateTime);
        campaignRecord.setSendTime(localDateTime);
        campaignRecord.setPageLang(1L);
        campaignRecord.setAllowedTurbo(1L);
        campaignRecord.setMetricaCounters("");
        campaignRecord.setUnmoderatedRtbAuction(0L);
        campaignRecord.setPerformanceTgoDisable(0L);
        campaignRecord.setTier(3L);
        campaignRecord.setOpts("{\"order_tags\": [1, 5], \"target_tags\": [1, 3, 5]}");
        campaignRecord.setCreatorId(0L);
        return campaignRecord;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public String getUserFixtureName() {
        return USER_FIXTURE_NAME;
    }

    @Override
    public String getSiteFixtureName() {
        return InternalSiteFixture.FIXTURE_NAME;
    }
}
