package ru.yandex.partner.testapi.fixture.page;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.InternalMobileAppRecord;
import ru.yandex.partner.libs.utils.JooqUtils;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;
import ru.yandex.partner.testapi.fixture.FixtureUtils;
import ru.yandex.partner.testapi.fixture.user.InternalUserFixture;
import ru.yandex.partner.testapi.service.PageIdGeneratorService;

@Component
public class InternalMobilePageFixture extends AbstractPageFixture {

    public static final String FIXTURE_NAME = "internal_mobile_page";

    public InternalMobilePageFixture(DSLContext dslContext, PageIdGeneratorService pageIdGeneratorService) {
        super(dslContext, pageIdGeneratorService);
    }

    @Override
    public String getUserFixtureName() {
        return InternalUserFixture.FIXTURE_NAME;
    }

    public InternalMobileAppRecord getDefaultMobileAppSettingsRecord(Long ownerId, Map<String, Object> patch) {
        LocalDateTime localDateTime = LocalDateTime.of(2018, 10, 4, 20, 37, 23);
        Long pageId = getAndUpdateNextPageId();
        InternalMobileAppRecord mobileAppRecord = new InternalMobileAppRecord();

        mobileAppRecord.setStoreId("ru.yandex.internal");
        mobileAppRecord.setType(1L);
        mobileAppRecord.setBehavioralTargeting(1L);
        mobileAppRecord.setBlocksCount(0L);
        mobileAppRecord.setBlocksLimit(400L);
        mobileAppRecord.setBlockTitle("");
        mobileAppRecord.setCaption("Mocked internal YAN Partner Mobile Page");
        mobileAppRecord.setComment("");
        mobileAppRecord.setCreateDate(localDateTime);
        mobileAppRecord.setCreatorId(ownerId);
        mobileAppRecord.setFalseClick(1L);
        mobileAppRecord.setFamilyFilter(0L);
        mobileAppRecord.setFastContext(1L);
        mobileAppRecord.setId(pageId);
        mobileAppRecord.setMultistate(1L); // working
        mobileAppRecord.setOnlyPicture(0L);
        mobileAppRecord.setOpts("{\"is_mobile_mediation\": 0}");
        mobileAppRecord.setPerformanceTgoDisable(0L);
        mobileAppRecord.setSendTime(localDateTime);
        mobileAppRecord.setTier(3L);
        mobileAppRecord.setUnmoderatedRtbAuction(0L);
        mobileAppRecord.setUpdateTime(localDateTime);
        mobileAppRecord.setViewImages(1L);

        JooqUtils.applyPatchToRecord(mobileAppRecord, patch);

        return mobileAppRecord;
    }

    @Override
    public List<FixtureResult> createAndSave(JsonNode optsJson, FixtureContext fixtureContext) {
        List<Map<String, Object>> patches = FixtureUtils.extractRecordPatches(optsJson);

        Long userId = getUserId(fixtureContext);

        List<InternalMobileAppRecord> records = patches.stream()
                .map(p -> getDefaultMobileAppSettingsRecord(userId, p))
                .toList();

        getDslContext().batchInsert(records).execute();

        return records.stream()
                .map(r -> new FixtureResult(
                        Long.toString(r.getId()),
                        Map.of(
                                "id", r.getId(),
                                "page_id", r.getId()
                        )
                )).toList();
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public List<String> getFixtureDepends() {
        return List.of(
                getUserFixtureName(),
                getDspFixtureName()
        );
    }
}
