package ru.yandex.partner.testapi.fixture.page;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteCampaignRecord;
import ru.yandex.partner.testapi.fixture.site.PartnerSiteFixture;
import ru.yandex.partner.testapi.service.PageIdGeneratorService;

import static ru.yandex.partner.dbschema.partner.tables.ContextOnSiteCampaign.CONTEXT_ON_SITE_CAMPAIGN;

@Component
public class PartnerContextPageFixture extends AbstractContextPageFixture {
    private static final String FIXTURE_NAME = "partner_context_page";
    private static final String USER_FIXTURE_NAME = "mocked_yan_partner";

    @Autowired
    public PartnerContextPageFixture(DSLContext dslContext, PageIdGeneratorService pageIdGeneratorService) {
        super(dslContext, pageIdGeneratorService);
    }

    @Override
    protected Table<? extends Record> getTable() {
        return CONTEXT_ON_SITE_CAMPAIGN;
    }

    private ContextOnSiteCampaignRecord getDefaultContextOnSiteCampaignRecord() {
//        Long pageId = getAndUpdateNextPageId();
        ContextOnSiteCampaignRecord siteCampaignRecord = new ContextOnSiteCampaignRecord();
//        siteCampaignRecord.setId(pageId);
//        siteCampaignRecord.setPageId(pageId);
        siteCampaignRecord.setCreateDate(localDateTime);
        siteCampaignRecord.setDomainId(1L);
        siteCampaignRecord.setOwnerId(0L);
        siteCampaignRecord.setCaption("Mocked YAN Partner Page");
        siteCampaignRecord.setFamilyFilter(0L);
        siteCampaignRecord.setBehavioralTargeting(1L);
        siteCampaignRecord.setViewImages(1L);
        siteCampaignRecord.setReloadTimeout(30L);
        siteCampaignRecord.setMultistate(2048L);
        siteCampaignRecord.setComment("");
        siteCampaignRecord.setBlockTitle("");
        siteCampaignRecord.setPiId(null);
        siteCampaignRecord.setFastContext(1L);
        siteCampaignRecord.setOnlyPicture(0L);
        siteCampaignRecord.setMobileAppMode(0L);
        siteCampaignRecord.setUserSynchronization(0L);
        siteCampaignRecord.setTagId(null);
        siteCampaignRecord.setAdblock(0L);
        siteCampaignRecord.setMarketApi(0L);
        siteCampaignRecord.setUpdateTime(localDateTime);
        siteCampaignRecord.setSendTime(localDateTime);
        siteCampaignRecord.setPageLang(1L);
        siteCampaignRecord.setAllowedAmp(1L);
        siteCampaignRecord.setAllowedTurbo(1L);
        siteCampaignRecord.setMetricaCounters("");
        siteCampaignRecord.setUnmoderatedRtbAuction(0L);
        siteCampaignRecord.setPerformanceTgoDisable(0L);
        siteCampaignRecord.setBlocksLimit(200L);
        siteCampaignRecord.setBlocksCount(0L);
        siteCampaignRecord.setTier(3L);
        siteCampaignRecord.setOpts("{\"order_tags\": [1, 5], \"target_tags\": [1, 3, 5]}");
        siteCampaignRecord.setCreatorId(0L);
        return siteCampaignRecord;
    }

    @Override
    protected Record getCampaignRecord(Long siteId, Long userId, Long pageId) {
        ContextOnSiteCampaignRecord siteCampaignRecord = getDefaultContextOnSiteCampaignRecord();

        siteCampaignRecord.setDomainId(siteId);
        siteCampaignRecord.setOwnerId(userId);
        siteCampaignRecord.setCreatorId(userId);

        siteCampaignRecord.setId(pageId);
        siteCampaignRecord.setPageId(pageId);

        return siteCampaignRecord;
    }

    @Override
    public String getUserFixtureName() {
        return USER_FIXTURE_NAME;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public String getSiteFixtureName() {
        return PartnerSiteFixture.FIXTURE_NAME;
    }
}
