package ru.yandex.partner.testapi.fixture.page;

import java.util.Map;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.MobileAppSettingsRecord;
import ru.yandex.partner.testapi.fixture.mobile.PartnerMobileMediationAppFixture;
import ru.yandex.partner.testapi.fixture.user.MockedYanPartnerFixture;
import ru.yandex.partner.testapi.service.PageIdGeneratorService;

@Component
public class PartnerMobileMediationPageFixture extends AbstractMobilePageFixture {
    private static final String FIXTURE_NAME = "partner_mobile_mediation_page";

    @Autowired
    public PartnerMobileMediationPageFixture(DSLContext dslContext, PageIdGeneratorService pageIdGeneratorService) {
        super(dslContext, pageIdGeneratorService);
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public String getUserFixtureName() {
        return MockedYanPartnerFixture.FIXTURE_NAME;
    }

    @Override
    public String getMobileAppFixtureName() {
        return PartnerMobileMediationAppFixture.FIXTURE_NAME;
    }

    @Override
    public MobileAppSettingsRecord getMobileAppSettingsRecord(Long mobileAppId, Long ownerId, Map<String,
            Object> optsMap) {
        MobileAppSettingsRecord mobileAppSettingsRecord = getDefaultMobileAppSettingsRecord(mobileAppId,
                ownerId, optsMap);
        mobileAppSettingsRecord.setOpts("{\"is_mobile_mediation\": 1, \"order_tags\": [], \"target_tags\": []}");
        return mobileAppSettingsRecord;
    }
}
