package ru.yandex.partner.testapi.fixture.page;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.testapi.fixture.mobile.PartnerMobileAppFixture;
import ru.yandex.partner.testapi.fixture.user.MockedYanPartnerFixture;
import ru.yandex.partner.testapi.service.PageIdGeneratorService;

@Component
public class PartnerMobilePageFixture extends AbstractMobilePageFixture {
    private static final String FIXTURE_NAME = "partner_mobile_page";

    @Autowired
    public PartnerMobilePageFixture(DSLContext dslContext, PageIdGeneratorService pageIdGeneratorService) {
        super(dslContext, pageIdGeneratorService);
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public String getUserFixtureName() {
        return MockedYanPartnerFixture.FIXTURE_NAME;
    }

    @Override
    public String getMobileAppFixtureName() {
        return PartnerMobileAppFixture.FIXTURE_NAME;
    }
}
