package ru.yandex.partner.testapi.fixture.page;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.Tables;
import ru.yandex.partner.dbschema.partner.tables.VideoAnSite;
import ru.yandex.partner.dbschema.partner.tables.VideoAnSiteCategories;
import ru.yandex.partner.dbschema.partner.tables.records.VideoAnSiteCategoriesRecord;
import ru.yandex.partner.dbschema.partner.tables.records.VideoAnSiteRecord;
import ru.yandex.partner.libs.utils.JooqUtils;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;
import ru.yandex.partner.testapi.fixture.FixtureUtils;
import ru.yandex.partner.testapi.fixture.user.MockedYanPartnerFixture;
import ru.yandex.partner.testapi.service.PageIdGeneratorService;

@Component
public class PartnerVideoPageFixture extends AbstractPageFixture {
    public static final String FIXTURE_NAME = "partner_video_page";

    @Autowired
    public PartnerVideoPageFixture(DSLContext dslContext, PageIdGeneratorService pageIdGeneratorService) {
        super(dslContext, pageIdGeneratorService);
    }

    @Override
    public String getUserFixtureName() {
        return MockedYanPartnerFixture.FIXTURE_NAME;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public List<String> getFixtureDepends() {
        return List.of(getUserFixtureName());
    }

    @Override
    public List<FixtureResult> createAndSave(JsonNode optsJson, FixtureContext fixtureContext) {
        // TODO: 28.03.2022 multiple video_an_site campaigns
        // подумать над зависимыми фикстурами
        var patch = FixtureUtils.extractRecordPatches(optsJson).get(0);

        var userId = getUserId(fixtureContext);
        var videoAnSiteRecord = JooqUtils.jsonToRecords(
                        "/data/fixtures/partner_video_page/video_an_site.json",
                        VideoAnSiteRecord::new)
                .get(0);

        Long pageId = getAndUpdateNextPageId();
        videoAnSiteRecord.setId(pageId);
        videoAnSiteRecord.setOwnerId(userId);
        videoAnSiteRecord.setCreatorId(userId);
        videoAnSiteRecord.setMultistate(20L); // to prevent agreement check

        JooqUtils.applyPatchToRecord(videoAnSiteRecord, patch);

        getDslContext().insertInto(VideoAnSite.VIDEO_AN_SITE)
                .set(videoAnSiteRecord)
                .execute();

        var records = JooqUtils.jsonToRecords(
                        "/data/fixtures/partner_video_page/video_an_site_categories.json",
                        VideoAnSiteCategoriesRecord::new);


        var mainCategoryRecord = records.get(0);
        mainCategoryRecord.setPageId(pageId);
        getDslContext()
                .insertInto(VideoAnSiteCategories.VIDEO_AN_SITE_CATEGORIES)
                .set(mainCategoryRecord)
                .execute();

        for (var record: records.subList(1, records.size())) {
            record.setPageId(pageId);
            record.setId(getNextCategoryIdFromSeq(pageId));
            getDslContext().insertInto(VideoAnSiteCategories.VIDEO_AN_SITE_CATEGORIES)
                    .set(record)
                    .execute();
        }


        return List.of(new FixtureResult(
                Long.toString(videoAnSiteRecord.getId()),
                Map.of("id", videoAnSiteRecord.getId())
        ));
    }

    protected Long getNextCategoryIdFromSeq(Long pageId) {
        return FixtureUtils.getNextId(pageId, getDslContext(),
                Tables.VIDEO_AN_SITE_CATEGORY_SEQ.SITE_ID,
                Tables.VIDEO_AN_SITE_CATEGORY_SEQ.NEXT_CATEGORY_ID);
    }
}
