package ru.yandex.partner.testapi.fixture.service.idprovider;

import java.util.concurrent.ConcurrentHashMap;

import org.springframework.stereotype.Service;

@Service
public class IdProviderService {
    private ConcurrentHashMap<IdClassEnum, Long> mapId;
    private Long initialValue = 1L;

    public IdProviderService() {
        mapId = new ConcurrentHashMap<>();
    }

    public void clearIdMap() {
        mapId.clear();
    }

    public Long getNextId(IdClassEnum idClass) {
        return mapId.compute(
                idClass,
                (k, v) -> v != null ? v + 1 : initialValue
        );
    }
}
