package ru.yandex.partner.testapi.fixture.site;

import java.time.LocalDateTime;

import org.jooq.DSLContext;

import ru.yandex.partner.testapi.fixture.Fixture;

public abstract class AbstractSiteFixture implements Fixture {
    private final DSLContext dslContext;
    private final LocalDateTime localDateTime = LocalDateTime.of(2020, 3, 31, 12, 0);

    public AbstractSiteFixture(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    public abstract String getDomainName();

    protected LocalDateTime getLocalDateTime() {
        return localDateTime;
    }

    protected DSLContext getDslContext() {
        return dslContext;
    }
}
