package ru.yandex.partner.testapi.fixture.site;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.InternalSiteRecord;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;

import static ru.yandex.partner.dbschema.partner.Tables.INTERNAL_SITE;

@Component
public class InternalSiteFixture extends AbstractSiteFixture {
    public static final String FIXTURE_NAME = "internal_site";
    private static final String DOMAIN_NAME = "internal.ru";

    public InternalSiteFixture(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public List<String> getFixtureDepends() {
        return Collections.emptyList();
    }

    @Override
    public List<FixtureResult> createAndSave(JsonNode optsJson, FixtureContext fixtureContext) {
        InternalSiteRecord record = new InternalSiteRecord();
        record.setDomain(getDomainName());

        InternalSiteRecord created = getDslContext().insertInto(INTERNAL_SITE)
                .set(record)
                .returning(INTERNAL_SITE.ID)
                .fetchOne();

        Long siteId = created.getId();

        return List.of(
                new FixtureResult(
                        siteId.toString(),
                        Map.of(
                                "id", siteId,
                                "domain", record.getDomain()
                        )
                )
        );
    }

    @Override
    public String getDomainName() {
        return DOMAIN_NAME;
    }
}
