package ru.yandex.partner.testapi.fixture.site;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.OwnerSiteRecord;
import ru.yandex.partner.dbschema.partner.tables.records.SiteRecord;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;
import ru.yandex.partner.testapi.fixture.user.MockedYanPartnerFixture;

import static ru.yandex.partner.dbschema.partner.tables.OwnerSite.OWNER_SITE;
import static ru.yandex.partner.dbschema.partner.tables.Site.SITE;

@Component
public class PartnerSiteFixture extends AbstractSiteFixture {
    public static final String FIXTURE_NAME = "partner_site";
    private static final String DOMAIN_NAME = "partner.ru";

    public PartnerSiteFixture(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    public String getDomainName() {
        return DOMAIN_NAME;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public List<String> getFixtureDepends() {
        return List.of(getUserFixtureName());
    }

    @Override
    public List<FixtureResult> createAndSave(JsonNode optsJson, FixtureContext fixtureContext) {
        Long userId = getUserId(fixtureContext);

        SiteRecord siteRecord = getSiteRecord();
        SiteRecord siteRecordId = getDslContext().insertInto(SITE)
                .set(siteRecord)
                .returning(SITE.ID)
                .fetchOne();
        // Получаем id сайта из автоинкрементного поля
        Long domainId = siteRecordId.getId();

        OwnerSiteRecord ownerSiteRecord = getOwnerSiteRecord(domainId, userId);
        getDslContext().insertInto(OWNER_SITE)
                .set(ownerSiteRecord).execute();

        return List.of(
                new FixtureResult(
                        domainId.toString(),
                        Map.of(
                                "id", domainId,
                                "domain", siteRecord.getDomain(),
                                "user_id", userId
                        )
                )
        );
    }

    private String getUserFixtureName() {
        return MockedYanPartnerFixture.FIXTURE_NAME;
    }

    private Long getUserId(FixtureContext fixtureContext) {
        List<FixtureResult> fixtureResult = fixtureContext.valueByFixtureName(getUserFixtureName());
        if (fixtureResult == null || fixtureResult.isEmpty()) {
            throw new RuntimeException("User fixture fail");
        }
        return (Long) fixtureResult.get(0).getParams().get("id");
    }

    private OwnerSiteRecord getOwnerSiteRecord(Long domainId, Long userId) {
        OwnerSiteRecord ownerSiteRecord = new OwnerSiteRecord();
        ownerSiteRecord.setDomainId(domainId);
        ownerSiteRecord.setUserId(userId);
        ownerSiteRecord.setCreateDate(getLocalDateTime());
        return ownerSiteRecord;
    }

    private SiteRecord getSiteRecord() {
        SiteRecord siteRecord = new SiteRecord();
        siteRecord.setDomain(getDomainName());
        siteRecord.setMultistate(4L);
        siteRecord.setCreateDate(getLocalDateTime());
        siteRecord.setIsGraysite(0L);
        return siteRecord;
    }
}
