package ru.yandex.partner.testapi.fixture.statistics.reports;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.StatisticsReportsRecord;
import ru.yandex.partner.libs.utils.JooqUtils;
import ru.yandex.partner.testapi.fixture.Fixture;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;

import static ru.yandex.partner.dbschema.partner.Tables.STATISTICS_REPORTS;

@ParametersAreNonnullByDefault
@Component
public class TemplateStatisticsReportFixture implements Fixture {
    private final DSLContext dslContext;
    public static final String FIXTURE_NAME = "template_statistics_report";
    private static final String PREFIX_PATH = "/data/fixtures/statistics_reports/";
    private final List<String> fixtures = new ArrayList<>();

    @Autowired
    public TemplateStatisticsReportFixture(DSLContext dslContext) {
        this.dslContext = dslContext;
        fixtures.add("all_context.json");
        fixtures.add("all_income.json");
        fixtures.add("all_income_adfox.json");
        fixtures.add("all_mobile.json");
        fixtures.add("all_video.json");
        fixtures.add("context_rtb_detailed_report.json");
        fixtures.add("context_rtb_tags_report.json");
        fixtures.add("mobmed_report_by_adv_type.json");
        fixtures.add("mobmed_report_by_day.json");
        fixtures.add("mobmed_report_by_monetizer.json");
        fixtures.add("mobmed_report_by_place.json");
        fixtures.add("mobile_rtb_detailed_report.json");
        fixtures.add("recwidget_detailed_report.json");
        fixtures.add("video_instream_block_detailed_report.json");
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public List<String> getFixtureDepends() {
        return List.of();
    }

    @Override
    public List<FixtureResult> createAndSave(JsonNode optsJson, FixtureContext fixtureContext) {
        List<String> fixturePaths = fixtures.stream()
                .map(f -> PREFIX_PATH + f)
                .toList();
        List<FixtureResult> resultList = new ArrayList<>();
        List<StatisticsReportsRecord> allRecords = new ArrayList<>();
        for (var path : fixturePaths) {
            List<StatisticsReportsRecord> records = JooqUtils.jsonToRecords(path, StatisticsReportsRecord::new);
            allRecords.addAll(records);

            resultList.add(new FixtureResult(records.get(0).getId()));
        }
        JooqUtils.insertRecords(dslContext, STATISTICS_REPORTS, allRecords);
        return resultList;
    }
}
