package ru.yandex.partner.testapi.fixture.user;

import java.util.List;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.page.InternalContextPageFixture;
import ru.yandex.partner.testapi.fixture.service.idprovider.IdProviderService;
import ru.yandex.partner.testapi.fixture.service.tus.TusService;

import static ru.yandex.partner.libs.rbac.role.RoleSet.INTERNAL_YAN_MANAGER;

@Component
public class InternalManagerFixture extends AbstractUserFixture {
    public static final String FIXTURE_NAME = "mocked_internal_manager";
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalManagerFixture.class);
    private List<Long> roleIds = List.of(
            INTERNAL_YAN_MANAGER.getRoleId()
    );
    private final ManagersFixtureService managersFixtureService;

    @Autowired
    public InternalManagerFixture(DSLContext dslContext,
                                  TusService tusService,
                                  IdProviderService idProviderService,
                                  ObjectMapper objectMapper,
                                  ManagersFixtureService managersFixtureService
    ) {
        super(dslContext, tusService, idProviderService, objectMapper, true);
        this.managersFixtureService = managersFixtureService;
    }

    @Override
    public void updateAdditionalTables(UsersRecord usersRecord, FixtureContext fixtureContext) {
        managersFixtureService.updateTable(usersRecord);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public List<Long> getRoleIds() {
        return roleIds;
    }

    @Override
    public List<String> getFixtureDepends() {
        return List.of(InternalContextPageFixture.FIXTURE_NAME);
    }
}
