package ru.yandex.partner.testapi.fixture.user;

import java.util.List;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.user.model.UserOptsHelper;
import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;
import ru.yandex.partner.testapi.fixture.service.idprovider.IdProviderService;
import ru.yandex.partner.testapi.fixture.service.tus.TusService;

import static ru.yandex.partner.libs.rbac.role.RoleSet.INTERNAL_YAN_ADMINISTRATOR;
import static ru.yandex.partner.libs.rbac.role.RoleSet.INTERNAL_YAN_MANAGER;
import static ru.yandex.partner.libs.rbac.role.RoleSet.INTERNAL_YAN_VIEWER;

@Component
public class InternalUserFixture extends AbstractUserFixture {
    public static final String FIXTURE_NAME = "internal_user";
    private static final String INTERNAL_USER_LOGIN = "adinside";
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalUserFixture.class);
    private final List<Long> roleIds = List.of(
            INTERNAL_YAN_MANAGER.getRoleId(),
            INTERNAL_YAN_ADMINISTRATOR.getRoleId(),
            INTERNAL_YAN_VIEWER.getRoleId()
    );

    protected InternalUserFixture(DSLContext dslContext,
                                  TusService tusService,
                                  IdProviderService idProviderService,
                                  ObjectMapper objectMapper) {
        super(dslContext, tusService, idProviderService, objectMapper, false);
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public UserOptsHelper getUserOpts() {
        UserOptsHelper userOpts = super.getUserOpts();
        userOpts.setHasRsya(true);
        userOpts.setHasApproved(true);
        userOpts.setContentBlockEditTemplateAllowed(true);
        userOpts.setHasCommonOffer(false);
        userOpts.setHasTutbyAgreement(false);
        userOpts.setHasMobileMediation(false);
        return userOpts;
    }

    @Override
    protected UsersRecord getUserRecord() {
        UsersRecord usersRecord = getDefaultUserRecord();
        usersRecord.setId(CoreConstants.ADINSIDE_USER_ID);
        usersRecord.setUid(CoreConstants.ADINSIDE_USER_ID);
        usersRecord.setClientId(CoreConstants.ADINSIDE_CLIENT_ID);
        usersRecord.setLogin(INTERNAL_USER_LOGIN);
        usersRecord.setMultistate(1L);

        return usersRecord;
    }

    @Override
    public List<Long> getRoleIds() {
        return roleIds;
    }
}
