package ru.yandex.partner.testapi.fixture.user;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.stereotype.Service;

import ru.yandex.partner.dbschema.partner.Tables;
import ru.yandex.partner.dbschema.partner.tables.records.ManagersRecord;
import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;

import static ru.yandex.partner.dbschema.partner.Tables.ALL_PAGES;

@Service
public class ManagersFixtureService {

    private final DSLContext dslContext;

    public ManagersFixtureService(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    public void updateTable(UsersRecord usersRecord) {

        List<ManagersRecord> managers = dslContext.select(ALL_PAGES.PAGE_ID)
                .from(ALL_PAGES)
                .stream()
                .map(r -> r.get(ALL_PAGES.PAGE_ID))
                .map(pageId -> {
                    var managersRecord = Tables.MANAGERS.newRecord();
                    managersRecord.setPageId(pageId);
                    managersRecord.setManagerId(usersRecord.getId());
                    return managersRecord;
                }).toList();

        dslContext.batchInsert(managers).execute();
    }
}
