package ru.yandex.partner.testapi.fixture.user;

import java.util.List;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;
import ru.yandex.partner.testapi.fixture.service.idprovider.IdProviderService;
import ru.yandex.partner.testapi.fixture.service.tus.TusService;

import static ru.yandex.partner.libs.rbac.role.RoleSet.ADFOX;
import static ru.yandex.partner.libs.rbac.role.RoleSet.DEVELOPER;
import static ru.yandex.partner.libs.rbac.role.RoleSet.YAN_MANAGER;

@Component
public class MockedAdfoxPiBotFixture extends AbstractUserFixture {
    public static final String FIXTURE_NAME = "mocked_adfox_pibot";
    private static final Logger LOGGER = LoggerFactory.getLogger(MockedAdfoxPiBotFixture.class);
    private static final String ADFOX_PIBOT_LOGIN = "yndx-robot-adfox-pibot";
    private List<Long> roleIds = List.of(
            ADFOX.getRoleId(),
            DEVELOPER.getRoleId(),
            YAN_MANAGER.getRoleId()
    );

    @Autowired
    public MockedAdfoxPiBotFixture(DSLContext dslContext,
                                   TusService tusService,
                                   IdProviderService idProviderService,
                                   ObjectMapper objectMapper) {
        super(dslContext, tusService, idProviderService, objectMapper, false);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    protected UsersRecord getUserRecord() {
        UsersRecord usersRecord = getDefaultUserRecord();
        usersRecord.setId(CoreConstants.ADFOX_PIBOT_USER_ID);
        usersRecord.setUid(CoreConstants.ADFOX_PIBOT_USER_ID);
        usersRecord.setLogin(ADFOX_PIBOT_LOGIN);
        return usersRecord;
    }

    @Override
    public List<Long> getRoleIds() {
        return roleIds;
    }

}
