package ru.yandex.partner.testapi.fixture.user;

import java.util.List;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.user.model.UserOptsHelper;
import ru.yandex.partner.libs.rbac.role.RoleSet;
import ru.yandex.partner.testapi.fixture.service.idprovider.IdProviderService;
import ru.yandex.partner.testapi.fixture.service.tus.TusService;

@Component
public class MockedDspPartnerFixture extends AbstractUserFixture {
    public static final String FIXTURE_NAME = "mocked_dsp_partner";
    private static final Logger LOGGER = LoggerFactory.getLogger(MockedDspPartnerFixture.class);
    private List<Long> roleIds = List.of(
            RoleSet.DSP_PARTNER.getRoleId()
    );

    @Autowired
    public MockedDspPartnerFixture(DSLContext dslContext,
                                   TusService tusService,
                                   IdProviderService idProviderService,
                                   ObjectMapper objectMapper) {
        super(dslContext, tusService, idProviderService, objectMapper, true);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public UserOptsHelper getUserOpts() {
        UserOptsHelper userOpts = super.getUserOpts();
        userOpts.setHasRsya(true);
        userOpts.setHasApproved(false);
        userOpts.setHasCommonOffer(false);
        userOpts.setHasTutbyAgreement(false);
        userOpts.setHasMobileMediation(false);
        return userOpts;
    }

    @Override
    public List<Long> getRoleIds() {
        return roleIds;
    }
}
