package ru.yandex.partner.testapi.fixture.user;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.user.model.UserOptsHelper;
import ru.yandex.partner.dbschema.partner.tables.records.FormDataRecord;
import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.service.idprovider.IdProviderService;
import ru.yandex.partner.testapi.fixture.service.tus.TusService;
import ru.yandex.partner.testapi.utils.ResourceUtils;

import static ru.yandex.partner.core.CoreConstants.RUSSIA_ID;
import static ru.yandex.partner.libs.rbac.role.RoleSet.VIDEO_PARTNER;

@Component
public class MockedUserRfIpFixture extends AbstractUserFixture {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockedUserRfIpFixture.class);
    private static final LocalDateTime LOCAL_DATE_TIME = LocalDateTime.of(2018, 6, 16, 18, 6, 56);
    private final List<Long> roleIds = List.of(
            VIDEO_PARTNER.getRoleId()
    );

    protected MockedUserRfIpFixture(
            DSLContext dslContext,
            TusService tusService,
            IdProviderService idProviderService,
            ObjectMapper objectMapper
    ) {
        super(dslContext, tusService, idProviderService, objectMapper, true);
    }

    @Override
    public String getFixtureName() {
        return "mocked_user_rf_ip";
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public UserOptsHelper getUserOpts() {
        var opts =  super.getUserOpts();

        opts.setCurrentCurrency("RUB");
        opts.setNextCurrency("EUR");
        opts.setCurrencyRate(BigDecimal.valueOf(66.6));
        return opts;
    }

    @Override
    protected void updateAdditionalTables(UsersRecord usersRecord, FixtureContext fixtureContext) {
        String branchId = "russia_ip";
        var record = new FormDataRecord();
        record.setDt(LOCAL_DATE_TIME);
        record.setUserId(usersRecord.getId());
        record.setClientId(usersRecord.getClientId());
        record.setCountryId(RUSSIA_ID);
        record.setBranchId(branchId);
        record.setData(
                ResourceUtils.readAsString("/data/fixtures/" + getFixtureName() + "/" + branchId + ".json")
        );
        record.setPersonId(5587041L);

        getDslContext().executeInsert(record);

        insertContract(usersRecord);
    }

    @Override
    public List<Long> getRoleIds() {
        return roleIds;
    }
}
