package ru.yandex.partner.testapi.fixture.user;

import java.time.LocalDateTime;
import java.util.List;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.FormDataRecord;
import ru.yandex.partner.dbschema.partner.tables.records.UserGlobalExcludedDomainsRecord;
import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.service.idprovider.IdProviderService;
import ru.yandex.partner.testapi.fixture.service.tus.TusService;
import ru.yandex.partner.testapi.utils.ResourceUtils;

import static ru.yandex.partner.core.CoreConstants.RUSSIA_ID;
import static ru.yandex.partner.libs.rbac.role.RoleSet.MOBILE_PARTNER;
import static ru.yandex.partner.libs.rbac.role.RoleSet.SITE_PARTNER;
import static ru.yandex.partner.libs.rbac.role.RoleSet.VIDEO_PARTNER;

@Component
public class MockedUserRfPhFixture extends AbstractUserFixture {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockedUserRfPhFixture.class);
    private static final LocalDateTime LOCAL_DATE_TIME = LocalDateTime.of(2018, 6, 16, 18, 6, 56);
    private final List<Long> roleIds = List.of(
            SITE_PARTNER.getRoleId(),
            MOBILE_PARTNER.getRoleId(),
            VIDEO_PARTNER.getRoleId()
    );

    protected MockedUserRfPhFixture(
            DSLContext dslContext,
            TusService tusService,
            IdProviderService idProviderService,
            ObjectMapper objectMapper
    ) {
        super(dslContext, tusService, idProviderService, objectMapper, true);
    }

    @Override
    public String getFixtureName() {
        return "mocked_user_rf_ph";
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void updateAdditionalTables(UsersRecord usersRecord, FixtureContext fixtureContext) {
        for (int n: List.of(1, 2)) {
            String branchId = "russia_ph_part" + n;
            var record = new FormDataRecord();
            record.setDt(LOCAL_DATE_TIME);
            record.setUserId(usersRecord.getId());
            record.setClientId(usersRecord.getClientId());
            record.setCountryId(RUSSIA_ID);
            record.setBranchId(branchId);
            record.setData(
                    ResourceUtils.readAsString("/data/fixtures/" + getFixtureName() + "/" + branchId + ".json")
            );
            if (n == 2) {
                record.setPersonId(5798470L);
            }
            getDslContext().executeInsert(record);
        }

        var excludedDomains = new UserGlobalExcludedDomainsRecord();
        excludedDomains.setUserId(usersRecord.getId());
        excludedDomains.setDomain("excluded.ru");

        getDslContext().executeInsert(excludedDomains);

        insertContract(usersRecord);
    }

    @Override
    public List<Long> getRoleIds() {
        return roleIds;
    }
}
