package ru.yandex.partner.testapi.fixture.user;

import java.util.List;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.testapi.fixture.service.idprovider.IdProviderService;
import ru.yandex.partner.testapi.fixture.service.tus.TusService;

import static ru.yandex.partner.libs.rbac.role.RoleSet.YAN_MANAGER;

@Component
public class MockedYanManagerFixture extends AbstractUserFixture {
    public static final String FIXTURE_NAME = "mocked_yan_manager";
    private static final Logger LOGGER = LoggerFactory.getLogger(MockedYanManagerFixture.class);
    private List<Long> roleIds = List.of(
            YAN_MANAGER.getRoleId()
    );

    @Autowired
    public MockedYanManagerFixture(DSLContext dslContext,
                                   TusService tusService,
                                   IdProviderService idProviderService,
                                   ObjectMapper objectMapper) {
        super(dslContext, tusService, idProviderService, objectMapper, true);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public List<Long> getRoleIds() {
        return roleIds;
    }

}
