package ru.yandex.partner.testapi.fixture.user;

import java.util.List;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.AssistantsRecord;
import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;
import ru.yandex.partner.testapi.fixture.service.idprovider.IdProviderService;
import ru.yandex.partner.testapi.fixture.service.tus.TusService;

import static ru.yandex.partner.libs.rbac.role.RoleSet.YAN_PARTNER_ASSISTANT;

@Component
public class MockedYanPartnerAssistantReadOnlyFixture extends AbstractUserFixture {
    public static final String FIXTURE_NAME = "partner_assistant_read_only";
    public static final String PAGE_FIXTURE_NAME = "partner_mobile_page";
    private static final Logger LOGGER = LoggerFactory.getLogger(MockedYanPartnerAssistantReadOnlyFixture.class);
    private final List<Long> roleIds = List.of(
            YAN_PARTNER_ASSISTANT.getRoleId()
    );

    protected MockedYanPartnerAssistantReadOnlyFixture(DSLContext dslContext,
                                                       TusService tusService,
                                                       IdProviderService idProviderService,
                                                       ObjectMapper objectMapper) {
        super(dslContext, tusService, idProviderService, objectMapper, true);
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    public String getPageFixtureName() {
        return PAGE_FIXTURE_NAME;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public List<Long> getRoleIds() {
        return roleIds;
    }

    @Override
    protected void updateAdditionalTables(UsersRecord usersRecord, FixtureContext fixtureContext) {
        AssistantsRecord assistantsRecord = new AssistantsRecord();
        assistantsRecord.setUserId(usersRecord.getId());
        List<FixtureResult> fixtureResult = fixtureContext.valueByFixtureName(getPageFixtureName());
        if (fixtureResult == null || fixtureResult.isEmpty()) {
            throw new RuntimeException("Page fixture fail");
        }
        Long pageId = (Long) fixtureResult.get(0).getParams().get("id");
        assistantsRecord.setPageId(pageId);
        assistantsRecord.setCanEdit(0L);

        getDslContext().executeInsert(assistantsRecord);
    }
}
