package ru.yandex.partner.testapi.fixture.user;

import java.util.List;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.user.model.UserOptsHelper;
import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;
import ru.yandex.partner.testapi.fixture.service.idprovider.IdProviderService;
import ru.yandex.partner.testapi.fixture.service.tus.TusService;

import static ru.yandex.partner.libs.rbac.role.RoleSet.MOBILE_PARTNER;
import static ru.yandex.partner.libs.rbac.role.RoleSet.SITE_PARTNER;
import static ru.yandex.partner.libs.rbac.role.RoleSet.VIDEO_PARTNER;

@Component
public class MockedYanPartnerFixture extends AbstractUserFixture {
    public static final String FIXTURE_NAME = "mocked_yan_partner";
    private static final Logger LOGGER = LoggerFactory.getLogger(MockedYanPartnerFixture.class);
    private List<Long> roleIds = List.of(
            SITE_PARTNER.getRoleId(),
            VIDEO_PARTNER.getRoleId(),
            MOBILE_PARTNER.getRoleId()
    );

    @Autowired
    public MockedYanPartnerFixture(DSLContext dslContext,
                                   TusService tusService,
                                   IdProviderService idProviderService,
                                   ObjectMapper objectMapper) {
        super(dslContext, tusService, idProviderService, objectMapper, true);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public UserOptsHelper getUserOpts() {
        UserOptsHelper userOpts = super.getUserOpts();
        userOpts.setHasRsya(true);
        userOpts.setHasApproved(true);
        userOpts.setHasCommonOffer(false);
        userOpts.setHasTutbyAgreement(false);
        userOpts.setHasMobileMediation(true);
        return userOpts;
    }

    @Override
    protected UsersRecord getUserRecord() {
        UsersRecord usersRecord = getDefaultUserRecord();
        usersRecord.setMultistate(1L);
        usersRecord.setIsAdfoxPartner(1L);
        return usersRecord;
    }

    @Override
    public List<Long> getRoleIds() {
        return roleIds;
    }

}
