package ru.yandex.partner.testapi.fixture.user;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.testapi.fixture.Fixture;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;
import ru.yandex.partner.testapi.fixture.service.tus.TusService;

@Component
public class OnlyPassportUserFixture implements Fixture {
    public static final String FIXTURE_NAME = "only_passport_user";
    private final TusService tusService;

    @Autowired
    public OnlyPassportUserFixture(TusService tusService) {
        this.tusService = tusService;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public List<String> getFixtureDepends() {
        return List.of();
    }

    @Override
    public List<FixtureResult> createAndSave(JsonNode optsJson, FixtureContext fixtureContext) {
        var tusUser = tusService.getOrCreateUser();
        return List.of(
                new FixtureResult(
                        Long.toString(tusUser.getUid()),
                        Map.of(
                                "id", tusUser.getUid(),
                                "login", tusUser.getLogin(),
                                "password", tusUser.getPassword()
                        )
                )
        );
    }
}
