package ru.yandex.partner.testapi.fixture.user;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;
import ru.yandex.partner.testapi.fixture.service.idprovider.IdProviderService;
import ru.yandex.partner.testapi.fixture.service.tus.TusService;

import static ru.yandex.partner.dbschema.partner.tables.Users.USERS;
import static ru.yandex.partner.libs.rbac.role.RoleSet.VIDEO_PARTNER;

@Component
public class SystemCronFixture extends AbstractUserFixture {
    private static final String FIXTURE_NAME = "system_cron";
    private final List<Long> roleIds = List.of(
            VIDEO_PARTNER.getRoleId()
    );
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemCronFixture.class);
    protected final LocalDateTime localDateTime = LocalDateTime.of(2018, 10, 4, 20, 37, 23);

    @Autowired
    public SystemCronFixture(DSLContext dslContext,
                                   TusService tusService,
                                   IdProviderService idProviderService,
                                   ObjectMapper objectMapper) {
        super(dslContext, tusService, idProviderService, objectMapper, false);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public List<Long> getRoleIds() {
        return roleIds;
    }

    @Override
    protected UsersRecord getUserRecord() {
        UsersRecord usersRecord = getDefaultUserRecord();
        usersRecord.setId(0L);
        usersRecord.setLogin("system-cron");
        usersRecord.setName("Cron");
        usersRecord.setLastname("");
        usersRecord.setMidname("");
        usersRecord.setEmail("partner-cron@yandex-team.ru");
        usersRecord.setPhone("");
        usersRecord.setAccountantEmail(null);
        usersRecord.setNewsletter(1L);
        usersRecord.setMultistate(1L);
        usersRecord.setCountryId(null);
        usersRecord.setBusinessUnit(0L);
        usersRecord.setNoStatMonitoringEmails(1L);
        usersRecord.setIsTutby(0L);
        usersRecord.setCreateDate(localDateTime);
        usersRecord.setNeedToEmailProcessing(0L);
        usersRecord.setBlockLightFormEnabled(0L);
        usersRecord.setIsMobileMediation(0L);
        usersRecord.setIsVideoBlogger(0L);
        usersRecord.setDomainLogin(null);
        usersRecord.setLastPayout(null);
        usersRecord.setIsAdfoxPartner(0L);
        usersRecord.setIsGames(0L);
        usersRecord.setIsDmLite(0L);
        usersRecord.setIsEfirBlogger(0L);
        usersRecord.setUid(0L);
        usersRecord.setIsDeleted(0L);
        usersRecord.setDeletionDate(null);
        return usersRecord;
    }

    @Override
    public List<FixtureResult> createAndSave(JsonNode optsJson, FixtureContext fixtureContext) {
        UsersRecord usersRecord = getUserRecord();
        usersRecord.setOpts(readOptsFromResource());
        dslContext.insertInto(USERS)
                .set(usersRecord)
                .execute();

        dslContext.update(USERS)
                .set(USERS.ID, 0L)
                .where(USERS.LOGIN.eq(usersRecord.getLogin()))
                .execute();

        insertUserRoles(usersRecord.getId());

        return List.of(
                new FixtureResult(
                        usersRecord.getId().toString(),
                        Map.of(
                                "id", usersRecord.getId(),
                                "login", usersRecord.getLogin()
                        )
                )
        );
    }
}
