package ru.yandex.partner.testapi.fixture.user;

import java.util.List;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.user.model.UserOptsHelper;
import ru.yandex.partner.testapi.fixture.service.idprovider.IdProviderService;
import ru.yandex.partner.testapi.fixture.service.tus.TusService;

import static ru.yandex.partner.libs.rbac.role.RoleSet.MOBILE_PARTNER;
import static ru.yandex.partner.libs.rbac.role.RoleSet.SITE_PARTNER;
import static ru.yandex.partner.libs.rbac.role.RoleSet.VIDEO_PARTNER;

@Component
public class TutbyPartnerUserFixture extends TutbyUserFixture {
    private List<Long> roleIds = List.of(
            SITE_PARTNER.getRoleId(),
            VIDEO_PARTNER.getRoleId(),
            MOBILE_PARTNER.getRoleId()
    );

    @Autowired
    public TutbyPartnerUserFixture(DSLContext dslContext,
                                   TusService tusService,
                                   IdProviderService idProviderService,
                                   ObjectMapper objectMapper) {
        super(dslContext, tusService, idProviderService, objectMapper);
    }

    @Override
    public String getFixtureName() {
        return "tutby_partner_user";
    }

    @Override
    public List<Long> getRoleIds() {
        return roleIds;
    }

    @Override
    public UserOptsHelper getUserOpts() {
        UserOptsHelper userOpts = super.getUserOpts();
        userOpts.setHasTutbyAgreement(true);
        return userOpts;
    }
}
