package ru.yandex.partner.testapi.fixture.user;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;
import ru.yandex.partner.testapi.fixture.service.idprovider.IdProviderService;
import ru.yandex.partner.testapi.fixture.service.tus.TusService;

@Component
public class TutbyUserFixture extends AbstractUserFixture {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockedYanPartnerFixture.class);

    @Autowired
    public TutbyUserFixture(DSLContext dslContext,
                            TusService tusService,
                            IdProviderService idProviderService,
                            ObjectMapper objectMapper) {
        super(dslContext, tusService, idProviderService, objectMapper, true);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getFixtureName() {
        return "tutby_user";
    }


    @Override
    protected UsersRecord getUserRecord() {
        UsersRecord usersRecord = getDefaultUserRecord();
        usersRecord.setIsTutby(1L);
        return usersRecord;
    }
}
