package ru.yandex.partner.testapi.fixture.user;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;
import ru.yandex.partner.testapi.fixture.service.idprovider.IdProviderService;
import ru.yandex.partner.testapi.fixture.service.tus.TusService;

@Component
public class YndxPartnerIntApiFixture extends AbstractUserFixture {
    public static final String FIXTURE_NAME = "yndx_partner_intapi";
    private static final Logger LOGGER = LoggerFactory.getLogger(YndxPartnerIntApiFixture.class);
    private static final String YNDX_PARTNER_INTAPI_LOGIN = "yndx-partner-intapi";

    @Autowired
    public YndxPartnerIntApiFixture(DSLContext dslContext,
                                    TusService tusService,
                                    IdProviderService idProviderService,
                                    ObjectMapper objectMapper) {
        super(dslContext, tusService, idProviderService, objectMapper, false);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    protected UsersRecord getUserRecord() {
        UsersRecord usersRecord = getDefaultUserRecord();
        usersRecord.setId(CoreConstants.INTAPI_USER_ID);
        usersRecord.setUid(CoreConstants.INTAPI_USER_ID);
        usersRecord.setLogin(YNDX_PARTNER_INTAPI_LOGIN);
        return usersRecord;
    }
}
