package ru.yandex.partner.testapi.fixture.widget;

import java.util.List;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;

import ru.yandex.partner.testapi.fixture.Fixture;
import ru.yandex.partner.testapi.fixture.user.MockedYanPartnerFixture;

public abstract class WidgetFixture implements Fixture {
    public static final String FIXTURE_NAME = "widget";
    protected final DSLContext dslContext;
    protected final ObjectMapper objectMapper;

    public WidgetFixture(DSLContext dslContext, ObjectMapper objectMapper) {
        this.dslContext = dslContext;
        this.objectMapper = objectMapper;
    }

    @Override
    public List<String> getFixtureDepends() {
        return List.of(getUserFixtureName());
    }

    protected String getUserFixtureName() {
        return MockedYanPartnerFixture.FIXTURE_NAME;
    }
}
