package ru.yandex.partner.testapi.jooq;

import java.util.Collection;

import org.jooq.ExecuteContext;
import org.jooq.impl.DefaultExecuteListener;
import org.springframework.stereotype.Component;

@Component
public class LoggingExecuteListener extends DefaultExecuteListener {
    // Ключ - название фикстуры
    // Значение - контейнер для таблиц
    // ConcurrentHashMap пока вроде не нужен, так как наливается все послежовательно
    private Collection<String> tablesContainer = null;

    public void start(Collection<String> tableContainer) {
        if (tablesContainer != null) {
            throw new IllegalStateException("LoggingExecuteListener in progress. Cannot start second process");
        }

        this.tablesContainer = tableContainer;
    }

    public void stop() {
        tablesContainer = null;
    }

    @Override
    public void executeStart(ExecuteContext ctx) {
        if (tablesContainer == null) {
            return;
        }
        String table = getTableNameIfInsert(ctx);
        if (table != null) {
            tablesContainer.add(table);
        }
    }

    private String getTableNameIfInsert(ExecuteContext ctx) {
        String prefix = "insert into `";
        String sql = ctx.query().getSQL();
        if (sql.startsWith(prefix)) {
            return sql.substring(prefix.length(), sql.indexOf('`', prefix.length()));
        }
        return null;
    }

}
