package ru.yandex.partner.testapi.service;

import java.time.LocalDateTime;

import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.partner.dbschema.partner.tables.records.PageIdGeneratorRecord;

import static ru.yandex.partner.dbschema.partner.tables.PageIdGenerator.PAGE_ID_GENERATOR;

@Service
public class PageIdGeneratorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageIdGeneratorService.class);
    private final DSLContext dslContext;

    public PageIdGeneratorService(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    /**
     * https://github.yandex-team.ru/partner/partner2/blob/4a7b0f4bf99a8058832023d431b68672b4c1facb/lib/QBit/Validator/Type/bk_data/page.pm#L44-L58
     * @param service
     * @return
     */
    public Long nextPageId(String service) {
        LOGGER.info("Call nextPageId for service: {}", service);
        PageIdGeneratorRecord record = new PageIdGeneratorRecord();
        record.setService(service);
        record.setDt(LocalDateTime.now());
        PageIdGeneratorRecord recordId = dslContext.insertInto(PAGE_ID_GENERATOR)
                .set(record)
                .returning(PAGE_ID_GENERATOR.PAGE_ID)
                .fetchOne();
        Long pageId = recordId.getPageId();
        pageId += 1000L;
        LOGGER.info("Get pageId: {}", pageId);
        return pageId;
    }
}
