package ru.yandex.partner.testapi.service.testcase;

import java.util.concurrent.locks.ReentrantLock;

import org.springframework.util.MultiValueMap;

import ru.yandex.partner.testapi.exceptions.TestApiConcurrentException;
import ru.yandex.partner.testapi.fixture.FixtureResult;

public class ConcurrentTestApiService implements TestApiService {
    private final ReentrantLock reentrantLock;
    private final TestApiService testApiService;

    public ConcurrentTestApiService(TestApiService testApiService) {
        this.testApiService = testApiService;
        this.reentrantLock = new ReentrantLock();
    }

    @Override
    public void processResourceTestcase(String testcase) {
        if (reentrantLock.isLocked()) {
            throw new TestApiConcurrentException();
        }
        reentrantLock.lock();
        try {
            testApiService.processResourceTestcase(testcase);
        } finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public void processFixtureList(FixtureListDto fixtureListDto) {
        if (reentrantLock.isLocked()) {
            throw new TestApiConcurrentException();
        }
        reentrantLock.lock();
        try {
            testApiService.processFixtureList(fixtureListDto);
        } finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public MultiValueMap<String, FixtureResult> getFixtureStateMap() {
        reentrantLock.lock();
        try {
            return testApiService.getFixtureStateMap();
        } finally {
            reentrantLock.unlock();
        }
    }
}
