package ru.yandex.partner.testapi.service.testcase;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;

class FixtureContextImpl implements FixtureContext {
    private final Map<String, List<FixtureResult>> values = new HashMap<>();

    @Override
    public List<FixtureResult> valueByFixtureName(String fixtureName) {
        return values.get(fixtureName);
    }

    public boolean contains(String fixtureName) {
        return values.containsKey(fixtureName);
    }

    void addValue(String fixtureName, List<FixtureResult> value) {
        values.put(fixtureName, value);
    }
}
