package ru.yandex.partner.testapi.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

import org.apache.commons.io.IOUtils;

public class ResourceUtils {
    private ResourceUtils() {
        // utils
    }

    public static String readAsString(String resourcePath) {
        try {
            InputStream is = ResourceUtils.class.getResourceAsStream(resourcePath);
            return IOUtils.toString(
                    Objects.requireNonNull(is, "resource not found: %s".formatted(resourcePath))
            );
        } catch (IOException e) {
            throw new RuntimeException(
                    String.format("Error during read resource %s", resourcePath), e);
        }
    }
}
