package ru.yandex.partner.webutils.controller;

import java.util.concurrent.TimeUnit;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.partner.webutils.model.ResponseObject;
import ru.yandex.yp.discovery.YpDiscoveryClient;
import ru.yandex.yp.discovery.YpDiscoveryClientBuilder;
import ru.yandex.yp.discovery.YpDiscoveryInstance;
import ru.yandex.yp.discovery.model.EndpointsResolveRequest;
import ru.yandex.yp.discovery.model.EndpointsResolveResponse;
import ru.yandex.yp.discovery.model.YpEndpointResolveStatus;
import ru.yandex.yp.discovery.model.YpEndpointSet;

@RestController
public class ApiController {
    @GetMapping("/info")
    public ResponseObject getInfo() {
        YpDiscoveryClient client = new YpDiscoveryClientBuilder(YpDiscoveryInstance.CROSS_DC,
                "Partner YP discovery client").build();
        try {
            EndpointsResolveRequest request = EndpointsResolveRequest.builder("vla", "partner-test-stage.Backend")
                    .addLabelSelector("/spec").build();
            EndpointsResolveResponse response =
                    client.serviceDiscoveryService().resolveEndpoints(request).get();
            YpEndpointResolveStatus status = response.getResolveStatus();
            if (status == YpEndpointResolveStatus.OK) {
                YpEndpointSet endpointSet = response.getEndpointSet().get();
            }

        } catch (Exception e) {
            //
        } finally {
            if (!client.shutdown(1, TimeUnit.SECONDS)) {
                client.shutdownNow(100, TimeUnit.MILLISECONDS);
            }
        }
        return new ResponseObject();
    }
}
