#!/bin/bash

HOST="$1"

if [[ "$HOST" == '' ]]
then
   # если соответствует условию [[ ? ]]
   HOST="dev4.partner.yandex.ru"
fi

HOSTS="/etc/hosts"
if [[ "$OSTYPE" == "linux-gnu" ]]; then
    HOSTS="/etc/hosts"
elif [[ "$OSTYPE" =~ ^darwin.*$ ]]; then
    HOSTS="/private/etc/hosts"
else
    echo "OS \"$OSTYPE\" is not supported"
    exit
fi

API_KEY_TOKEN=$(ssh "$USER@$HOST" 'cat /etc/pi-secrets.json | jq -r .[\"apikey-token\"]')

TVM_PORT=18080
DEPLOY_TVM_TOOL_URL="http://localhost:$TVM_PORT"
TVMTOOL_LOCAL_AUTHTOKEN=$(ssh "$USER@$HOST" 'cat /var/lib/tvmtool/local.auth')

DB_CONFIG=$(ssh "$USER@$HOST" 'perl -E "use Partner::DB; use JSON; print to_json(Partner::DB::get_db_partner2(server => dev));"')

MYSQL_HOST=$(echo "$DB_CONFIG" | jq -r '.["host"]')
MYSQL_PORT=$(echo "$DB_CONFIG" | jq -r '.["port"]')
MYSQL_USER=$(echo "$DB_CONFIG" | jq -r '.["user"]')
MYSQL_PASSWORD=$(echo "$DB_CONFIG" | jq -r '.["password"]')
SECRET_PARTNER2_CLICKHOUSE_USER=$(ssh "$USER@$HOST" 'cat /etc/pi-secrets.json | jq -r .[\"partner2-clickhouse-user-testing\"]')
SECRET_PARTNER2_CLICKHOUSE_PASSWORD=$(ssh "$USER@$HOST" 'cat /etc/pi-secrets.json | jq -r .[\"partner2-clickhouse-password-testing\"]')
SECRET_YQL_TOKEN=$(ssh "$USER@$HOST" 'cat /etc/pi-secrets.json |  jq -r .[\"yql-token\"] /etc/pi-secrets.json')
SECRET_YT_TOKEN=$(ssh "$USER@$HOST" 'cat /etc/pi-secrets.json | jq -r .[\"yt-token\"] /etc/pi-secrets.json')
JUGGLER_OAUTH_TOKEN=$(ssh "$USER@$HOST" 'cat /etc/pi-secrets.json | jq -r .[\"juggler-token\"] /etc/pi-secrets.json')

#tvm
if ! lsof -t -i ":$TVM_PORT"; then
    ssh -f -N -L  "$TVM_PORT:localhost:$TVM_PORT" "$USER@$HOST"
fi

#mysql
if ! lsof -t -i ":$MYSQL_PORT"; then
    ssh -f -N -L  "$MYSQL_PORT:localhost:$MYSQL_PORT" "$USER@$HOST"
fi

#unified agent
if ! lsof -t -i :16400; then
    ssh -f -N -L  16400:localhost:16400 "$USER@$HOST"
fi

#memcached
if ! lsof -t -i :11211; then
    ssh -f -N -L  11211:localhost:11211 "$USER@$HOST"
fi

#solomon agent
if ! lsof -t -i :22001; then
    ssh -f -N -L  22001:localhost:22001 "$USER@$HOST"
fi

#apikeys
if ! lsof -t -i :8666; then
    ssh -f -N -L 8666:apikeys-test.paysys.yandex.net:8666 "$USER@$HOST"
fi

if ! grep -e '127.0.0.1\sapikeys-test.paysys.yandex.net' "$HOSTS"; then
    sudo sh -c "echo \"127.0.0.1\tapikeys-test.paysys.yandex.net\" >> $HOSTS"
fi


#blackbox
if ! lsof -t -i :8667; then
    ssh -f -N -L 8667:blackbox-mimino.yandex.net:80 "$USER@$HOST"
fi

if ! grep -e '127.0.0.1\sblackbox-mimino.yandex.net' "$HOSTS"; then
    sudo sh -c "echo \"127.0.0.1\tblackbox-mimino.yandex.net\" >> $HOSTS"
fi

#balance
if ! lsof -t -i :8002; then
    ssh -f -N -L 8002:greed-ts.paysys.yandex.ru:8002 "$USER@$HOST"
fi

if ! grep -e '127.0.0.1\sgreed-ts.paysys.yandex.ru' "$HOSTS"; then
    sudo sh -c "echo \"127.0.0.1\tgreed-ts.paysys.yandex.ru\" >> $HOSTS"
fi

#direct
if ! lsof -t -i :9876; then
    ssh -f -N -L 9876:intapi.test.direct.yandex.ru:80 "$USER@$HOST"
fi

if ! grep -e '127.0.0.1\sintapi.test.direct.yandex.ru' "$HOSTS"; then
    sudo sh -c "echo \"127.0.0.1\tintapi.test.direct.yandex.ru\" >> $HOSTS"
fi

#saas
if ! lsof -t -i :17000; then
    ssh -f -N -L 17000:saas-searchproxy-prestable.yandex.net:17000 "$USER@$HOST"
fi

if ! grep -e '127.0.0.1\ssaas-searchproxy-prestable.yandex.net' "$HOSTS"; then
    sudo sh -c "echo \"127.0.0.1\tsaas-searchproxy-prestable.yandex.net\" >> $HOSTS"
fi

#juggler
if ! lsof -t -i :8668; then
    ssh -f -N -L 8668:juggler-push.search.yandex.net:80 "$USER@$HOST"
fi

if ! grep -e '127.0.0.1\sjuggler-push.search.yandex.net' "$HOSTS"; then
    sudo sh -c "echo \"127.0.0.1\tjuggler-push.search.yandex.net\" >> $HOSTS"
fi

echo ""
echo "API_KEY_TOKEN=$API_KEY_TOKEN;DEPLOY_TVM_TOOL_URL=$DEPLOY_TVM_TOOL_URL;TVMTOOL_LOCAL_AUTHTOKEN=$TVMTOOL_LOCAL_AUTHTOKEN;MYSQL_HOST=$MYSQL_HOST;MYSQL_PORT=$MYSQL_PORT;MYSQL_USER=$MYSQL_USER;MYSQL_PASSWORD=$MYSQL_PASSWORD;SECRET_PARTNER2_CLICKHOUSE_USER=$SECRET_PARTNER2_CLICKHOUSE_USER;SECRET_PARTNER2_CLICKHOUSE_PASSWORD=$SECRET_PARTNER2_CLICKHOUSE_PASSWORD;SECRET_YQL_TOKEN=$SECRET_YQL_TOKEN;SECRET_YT_TOKEN=$SECRET_YT_TOKEN;BLACKBOX_HTTP_PORT=8667;JUGGLER_OAUTH_TOKEN=$JUGGLER_OAUTH_TOKEN;JUGGLER_PORT=8668;DIRECT_INTAPI_PORT=9876;"
