OWNER(g:partner)

#INCLUDE(${ARCADIA_ROOT}/library/java/dependency_managment.inc)

LINT(extended)
CHECK_JAVA_DEPS(yes)
#USE_ERROR_PRONE()

JDK_VERSION(17)

SET(jooq_version 3.15.4)
SET(jackson_version 2.12.3)
SET(slf4j_version 1.7.25)
SET(logback_version 1.2.10)
SET(sentry_version 1.7.5)

SET(spring_version 5.3.10)
SET(spring_security_version 5.5.0)
SET(spring_boot_version 2.5.5)

SET(crnk_version 3.3.20200920055408)

SET(netty_version 4.1.68.Final)

SET(byte_buddy_version 1.9.3)
SET(asm_version 7.0)

SET(jupiter_version 5.5.2)
SET(assertj_version 3.7.0)
SET(mockito_version 2.23.4)
SET(archunit_version 0.10.2)

SET(mapstruct_version 1.4.1.Final)

SET(mockwebserver_version 3.12.0)

# Здесь перечислены конкретные версии библиотек, которые нужно игнорировать,
# так как они вызывают конфликты с подключаемыми в других местах
EXCLUDE(
    devtools/junit-runner
    contrib/java/org/springframework/boot/spring-boot-starter-tomcat/${spring_boot_version}

    contrib/java/commons-io/commons-io/2.5

    contrib/java/javax/servlet/servlet-api/2.3
    contrib/java/javax/servlet/servlet-api/2.4
    contrib/java/javax/servlet/servlet-api/2.5
    contrib/java/javax/servlet/javax.servlet-api/3.1.0
    contrib/java/javax/servlet/javax.servlet-api/3.0.1
    contrib/java/javax/websocket/javax.websocket-client-api/1.0
    contrib/java/javax/websocket/javax.websocket-api/1.0
    contrib/java/javax/annotation/javax.annotation-api/1.2
    contrib/java/javax/annotation/javax.annotation-api/1.3.1
    contrib/java/javax/annotation/javax.annotation-api/1.3.2
    contrib/java/javax/activation/javax.activation-api/1.2.0
    contrib/java/com/sun/activation/javax.activation/1.2.1
    contrib/java/com/sun/activation/javax.activation/1.2.0

    contrib/java/org/lz4/lz4-java/1.4.1
    contrib/java/org/lz4/lz4-java/1.6.0
    contrib/java/org/lz4/lz4-java/1.7.1
    contrib/java/org/json/json/20160212

    contrib/java/org/ow2/asm/asm-all/5.0.2
    contrib/java/org/ow2/asm/asm-all/5.0.3
    contrib/java/com/google/code/findbugs/annotations/2.0.3
    contrib/java/com/google/code/findbugs/annotations/3.0.1
    contrib/java/commons-beanutils/commons-beanutils-core/1.8.3

    contrib/java/net/minidev/accessors-smart/1.1

    # exclude all of commons-logging versions
    # replaced with jcl-over-slf4j
    contrib/java/commons-logging/commons-logging
    # exclude every log4j thing, mostly transitive versions (2.11.(0|2)) with 0day CVE-2021-44228
    # replaced with log4j-over-slf4j
    contrib/java/org/apache/logging/log4j

    contrib/java/org/dom4j/dom4j/2.1.3

    # exclude oldest log4j and logback
    contrib/java/log4j/log4j/1.2.17
    contrib/java/ch/qos/logback/logback-classic/1.2.3

    contrib/java/com/google/protobuf/protobuf-javalite/3.19.2
)

INCLUDE(${ARCADIA_ROOT}/contrib/java/org/junit/junit-bom/${jupiter_version}/junit-bom.bom.inc)
DEPENDENCY_MANAGEMENT(
    contrib/java/com/fasterxml/jackson/jaxrs/jackson-jaxrs-base/${jackson_version}
    contrib/java/com/fasterxml/jackson/core/jackson-annotations/${jackson_version}
    contrib/java/com/fasterxml/jackson/core/jackson-core/${jackson_version}
    contrib/java/com/fasterxml/jackson/core/jackson-databind/${jackson_version}
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-cbor/${jackson_version}
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-xml/${jackson_version}
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-yaml/${jackson_version}
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-guava/${jackson_version}
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-jsr310/${jackson_version}
    contrib/java/com/fasterxml/jackson/module/jackson-module-jaxb-annotations/${jackson_version}
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-jdk8/${jackson_version}

    contrib/java/org/jooq/jooq/${jooq_version}
    contrib/java/org/mapstruct/mapstruct/${mapstruct_version}
    contrib/java/org/mapstruct/mapstruct-processor/${mapstruct_version}

    contrib/java/org/springframework/spring-aop/${spring_version}
    contrib/java/org/springframework/spring-beans/${spring_version}
    contrib/java/org/springframework/spring-context/${spring_version}
    contrib/java/org/springframework/spring-core/${spring_version}
    contrib/java/org/springframework/spring-jdbc/${spring_version}
    contrib/java/org/springframework/spring-oxm/${spring_version}
    contrib/java/org/springframework/spring-test/${spring_version}
    contrib/java/org/springframework/spring-tx/${spring_version}
    contrib/java/org/springframework/spring-web/${spring_version}
    contrib/java/org/springframework/spring-webmvc/${spring_version}
    contrib/java/org/springframework/spring-expression/${spring_version}
    contrib/java/org/springframework/spring-webflux/${spring_version}

    contrib/java/org/springframework/security/spring-security-core/${spring_security_version}
    contrib/java/org/springframework/security/spring-security-web/${spring_security_version}

    contrib/java/org/springframework/boot/spring-boot/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-actuator/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-actuator-autoconfigure/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-autoconfigure/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-configuration-processor/${spring_boot_version}

    contrib/java/org/springframework/boot/spring-boot-starter/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-aop/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-jetty/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-reactor-netty/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-jdbc/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-web/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-actuator/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-validation/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-json/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-cache/${spring_boot_version}

    contrib/java/org/springframework/boot/spring-boot-starter-security/${spring_boot_version}

    contrib/java/org/springframework/boot/spring-boot-test-autoconfigure/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-test/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-test/${spring_boot_version}



    contrib/java/io/crnk/crnk-setup-spring-boot2/${crnk_version}
    contrib/java/io/crnk/crnk-home/${crnk_version}

    contrib/java/io/netty/netty-buffer/${netty_version}
    contrib/java/io/netty/netty-codec/${netty_version}
    contrib/java/io/netty/netty-codec-http/${netty_version}
    contrib/java/io/netty/netty-common/${netty_version}
    contrib/java/io/netty/netty-handler/${netty_version}
    contrib/java/io/netty/netty-transport/${netty_version}
    contrib/java/io/netty/netty-transport-native-epoll-linux-x86_64/${netty_version}
    contrib/java/io/netty/netty-codec-http2/${netty_version}
    contrib/java/io/netty/netty-codec-socks/${netty_version}
    contrib/java/io/netty/netty-handler-proxy/${netty_version}
    contrib/java/io/netty/netty-resolver/${netty_version}

    contrib/java/org/assertj/assertj-core/${assertj_version}
    contrib/java/org/mockito/mockito-core/${mockito_version}
    contrib/java/org/skyscreamer/jsonassert/1.5.0
    contrib/java/com/squareup/okhttp3/mockwebserver/${mockwebserver_version}

    contrib/java/com/tngtech/archunit/archunit-junit5-engine/${archunit_version}
    contrib/java/com/tngtech/archunit/archunit-junit5-api/${archunit_version}
    contrib/java/com/tngtech/archunit/archunit-junit5-engine-api/${archunit_version}
    contrib/java/com/tngtech/archunit/archunit/${archunit_version}

    contrib/java/org/slf4j/slf4j-api/${slf4j_version}
    contrib/java/org/slf4j/log4j-over-slf4j/${slf4j_version}
    contrib/java/org/slf4j/jcl-over-slf4j/${slf4j_version}
    contrib/java/ch/qos/logback/logback-classic/${logback_version}
    contrib/java/net/logstash/logback/logstash-logback-encoder/5.0

    contrib/java/net/bytebuddy/byte-buddy-agent/${byte_buddy_version}
    contrib/java/net/bytebuddy/byte-buddy/${byte_buddy_version}

    contrib/java/com/zaxxer/HikariCP/3.2.0
    contrib/java/mysql/mysql-connector-java/8.0.19

    contrib/java/org/ow2/asm/asm/${asm_version}
    contrib/java/org/ow2/asm/asm-commons/${asm_version}
    contrib/java/org/ow2/asm/asm-tree/${asm_version}

    contrib/java/com/google/guava/guava/27.1-jre
    contrib/java/com/github/jgonian/commons-ip-math/1.32
    contrib/java/org/apache/commons/commons-collections4/4.3
    contrib/java/org/apache/commons/commons-io/1.3.2
    contrib/java/org/apache/commons/commons-lang3/3.8.1

    contrib/java/one/util/streamex/0.7.3

    contrib/java/ru/yandex/clickhouse/clickhouse-jdbc/0.2.6

    contrib/java/io/sentry/sentry-spring/${sentry_version}
    contrib/java/io/sentry/sentry-logback/${sentry_version}

    contrib/java/net/minidev/asm

    contrib/java/org/reflections/reflections/0.9.12
    contrib/java/org/jetbrains/kotlin/kotlin-reflect/1.5.21

    contrib/java/jakarta/servlet/jakarta.servlet-api/4.0.4
    contrib/java/jakarta/websocket/jakarta.websocket-api/1.1.2
    contrib/java/jakarta/xml/bind/jakarta.xml.bind-api/3.0.0

    contrib/java/jakarta/annotation/jakarta.annotation-api/1.3.5
    contrib/java/jakarta/activation/jakarta.activation-api/1.2.2

    contrib/java/com/sun/activation/jakarta.activation/2.0.1
)
