package ru.yandex.partner.coreexperiment.entity.field;

import java.time.LocalDateTime;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnore;

import ru.yandex.partner.coreexperiment.ModelFieldInterface;

public class CreateDate implements ModelFieldInterface {
    private LocalDateTime createDate;

    public CreateDate(LocalDateTime createDate) {
        this.createDate = createDate;
    }

    public LocalDateTime getCreateDate() {
        return createDate;
    }

    @JsonIgnore
    public LocalDateTime getValue() {
        return this.getCreateDate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDate)) {
            return false;
        }
        CreateDate that = (CreateDate) o;
        return createDate.equals(that.createDate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(createDate);
    }
}
