package ru.yandex.partner.coreexperiment.entity.field;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnore;

import ru.yandex.partner.coreexperiment.ModelFieldInterface;

public class Id implements ModelFieldInterface {
    private Long id;

    public Id(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    @JsonIgnore
    public Long getValue() {
        return this.getId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Id)) {
            return false;
        }
        Id id1 = (Id) o;
        return Objects.equals(id, id1.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
