package ru.yandex.partner.coreexperiment.entity.field;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnore;

import ru.yandex.partner.coreexperiment.ModelFieldInterface;

public class Multistate implements ModelFieldInterface {
    private Long multistate;

    public Multistate(Long multistate) {
        this.multistate = multistate;
    }

    public Long getMultistate() {
        return multistate;
    }

    @JsonIgnore
    public Long getValue() {
        return this.getMultistate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Multistate)) {
            return false;
        }
        Multistate that = (Multistate) o;
        return multistate.equals(that.multistate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(multistate);
    }
}
